# Review A Review on Sonochemistry and Its Environmental Applications

Ba¸sak Savun-Hekimo ˘glu

Institute of Marine Sciences and Management, Istanbul University, 34134 ˙Istanbul, Turkey; basak.savun@istanbul.edu.tr

Received: 10 September 2020; Accepted: 23 October 2020; Published: 25 October 2020

Abstract: Sonochemistry is a significant contributor to green science as it includes: (i) the use of less toxic compounds and environmentally safe solvents, (ii) improvement of reaction conditions and selectivity, (iii) no toxic sludge generation, (iv) reduction in the energy use for chemical transformations, (v) reusability of materials. In water and wastewater treatment, ultrasound is used as an advanced oxidation process to eliminate refractory pollutants. Ultrasound is also used as a very effective sludge pretreatment technology in wastewater treatment plants to facilitate biogas production. Moreover, sonochemical synthesis of nanoparticles has recently attracted great attention as a greener protocol. This paper presents the main applications of ultrasound in environmental remediation and protection. The study also introduces mechanism for the degradation of pollutants from water via sonication in aqueous media and the principle factors affecting the cavitational effect.

Keywords: ultrasound; sonocatalysis; water treatment; sludge pretreatment; nanomaterials

# 1. Introduction to Sonochemistry

Sonochemistry is a field that studies the enhancement of chemical reaction and mass transfer rates under various ultrasonic conditions. Ultrasound is characterized as any sound wave at frequencies above normal human ear hearing range (i.e., above $1 6 \mathrm { k H z }$ ). The mechanism causing sonochemical effects in liquids is the phenomenon of acoustic cavitation. When ultrasound waves propagate in a liquid medium, they generate a repeating pattern of compressions and rarefactions to supply energy to the liquid phase. Compression and rarefaction cycles exert positive and negative pressure on the liquid pushing or pulling the molecules together or away from one another, respectively [1].

Three successive steps of the phenomenon called acoustic cavitation are: (i) nucleation, (ii) bubble growth (expansion), (iii) implosive collapse [1]. In the first stage, microbubbles trapped in micro-crevices of small particles within the liquid form cavitational nuclei, where cavities are generated depending on the type and purity of the liquid [1,2]. The second stage is when the microbubbles have been formed, and when the intensity is too high a small cavity can quickly develop as a result of inertial effects [1]. The cavity expands by rectified diffusion when the acoustic intensity is low, and it lasts another few acoustic cycles before expansion [1]. The third stage is when the cavity is so overgrown that it can no longer absorb energy to sustain itself, and the surrounding liquid rushes in to lead to a violent implosion as a catastrophic collapse [1–4]. At this point, the extremes of temperatures and pressures create an unusual environment or high-energy micro-reactors that enable molecular fragmentation of the entrapped gases in the collapsing cavities [5]. The following equations (Equations (1)–(5)) show the reactions of hydroxyl radicals generated by sonication [6]:

$$
\mathrm { H } _ { 2 } \mathrm { O } + \mathrm { O } ) )  { \bullet } \mathrm { O H } + { \bullet } \mathrm { H } ( \mathrm { p y r o l y s i s } )
$$

$$
\bullet \mathrm { O H } + \bullet \mathrm { H }  \mathrm { H } _ { 2 } \mathrm { O }
$$

$$
\begin{array} { c } { { 2 \bullet \mathrm { O H }  \mathrm { H } _ { 2 } + \mathrm { O } _ { 2 } } } \\ { { { } } } \\ { { 2 \bullet \mathrm { O H }  \mathrm { H } _ { 2 } \mathrm { O } _ { 2 } } } \\ { { { } } } \\ { { 2 \bullet \mathrm { H }  \mathrm { H } _ { 2 } } } \end{array}
$$

Chemical reactions in homogenous sonolysis proceed via radical intermediates [7], meaning that the severe conditions in collapsing microbubbles cause homogenous sonochemistry. Although many organic compounds can be degraded by homogenous sonication, the decomposition rates might still be slow for practical uses [8]. Thus, considerable efforts have been made to accelerate the decomposition rates of organic contaminants in water by ultrasound. Previous studies found that the introduction of heterogeneous surfaces increases the extent of interfacial cavitation. Thus, addition of solid particles serves as an additional nucleus, increasing the numbers of cavitation events and accelerating the rate of decomposition [9–11]. Improvement of chemical reactivity is related to physical effects of the ultrasound in heterogeneous sonochemical systems, such as heat and mass transfer, activation of the surface and interference of the solid due to jetting [1]. On the other hand, the solid particles may scatter the ultrasonic wave in water, weaken the energy dissipation into water, pertibute bubble distribution and decrease the removal efficiency. Therefore, understanding the effect of solid particles on sonolysis is important as their presence may exhibit different influences on degradation kinetics.

Another consequence of acoustic cavitation in a liquid is the emission of light from the collapsing bubbles. Hence, in addition to driving chemical reactions, ultrasonic irradiation of liquids can also produce light and this phenomenon is called sonoluminescence (SL). Two types of SL are multi-bubble sonoluminescence (MBSL) and single-bubble sonoluminescence (SBSL) [12]. MBSL is the light emission that occurs from a cloud of cavitating bubbles, whereas SBSL occurs from a single cavitating bubble. Due to increased sphericity of the collapse, which arises from the isolation of the bubble from perturbations, much higher temperatures and pressures are thought to be generated during SBSL compared to MBSL [13]. Cavitational collapse produces “sonoluminescence”, i.e., an intense UV irradiation of a wide wavelength range $( 2 0 0 - 5 0 0 \mathrm { n m } )$ ) [14]. The wavelengths shorter than $3 7 5 \mathrm { n m }$ can excite the surface of $\mathrm { T i O } _ { 2 }$ just like in photocatalytic processes [15]. The explanation for this phenomenon is the hot spot theory, which basically states that when a bubble collapses sufficiently fast, its contents are strongly compressed to lead to an adiabatic temperature rise for light emission in the form of short flashes [16]. The flash duration (and intensity) depends on several details of bubble collapse (such as frequency, sound pressure amplitude, type of liquid and the gas inside the bubble) [17].

# 1.1. The Reaction Sites in Acoustic Cavitation Processes

In homogenous sonochemistry, there are three main reaction sites: the cavitation bubble, the interface between gas bubbles and the surrounding liquid, and the bulk solution, as schematized in Figure 1 [18]. The decomposition of organic molecules takes place either inside the bubble if they are highly volatile, or at the bulk liquid and the gas–liquid interface [19]. Oxidation reactions in the bulk solution are limited by the number of available, uncombined, free radicals that have migrated from the collapsing cavities and the interface into the bulk [20]. Hydrophilic compounds with low volatility are not expected to migrate towards the bubble or the interfacial region, but rather remain in the bulk solution. Hydrophobic compounds that are highly volatile readily diffuse into the cavitation bubbles, where pyrolysis and oxidation with the OH radical are the predominant phenomena. Finally, the gas–liquid interface is the most probable reaction site for water contaminants, and, owing to the high concentration of •OH (relative to that in the bulk solution) and sufficient pressure gradients and temperatures, the reactions proceed at considerably high rates.

![](images/561b766b6f546ef898cf993e0da415689b6998be57e823f3454fc0302110112f.jpg)  
Figure 1. Main reaction sites in homogenous sonochemistry [18].Figure 1. Main reaction sites in homogenous sonochemistry [18].

The fate of highly soluble water contaminants in the bulk solution is related to the rate ofThe fate of highly soluble water contaminants in the bulk solution is related to the rate of $\bullet \mathrm { O H }$ radical transfer from the bubble interior (and its interfacial sheath) into the bulk solution, which inradical transfer from the bubble interior (and its interfacial sheath) into the bulk solution, which in turn is a function of the duration of cavities, the intensity of the pressure, the geometry of the reactorturn is a function of the duration of cavities, the intensity of the pressure, the geometry of the reactor and the frequency of the applied ultrasound waves [3,6]. Some of these parameters are described in and the frequency of the applied ultrasound waves [3,6]. Some of these parameters are described in the following section.the following section.

# 1.2. Parameters Affecting Sonochemical Reactions

The main parameters affecting the sonolytic degradation efficiencies are the frequency of The main parameters affecting the sonolytic degradation efficiencies are the frequency of ultrasonic waves, properties of the target solute, power intensity, applied bubbling gas, temperature, ultrasonic waves, properties of the target solute, power intensity, applied bubbling gas, temperature, physicochemical properties of the pollutant and addition of solids as catalysts to the system.physicochemical properties of the pollutant and addition of solids as catalysts to the system.

# 1.2.1. Frequency

Frequency has a very important role in sonication and three ranges are reported: (i) low frequency $( 2 0 – 1 0 0 \mathrm { k H z } )$ , (ii) medium frequency $( 3 0 0 { - } 1 0 0 0 \mathrm { k H z } )$ , and high frequency $( 2 { - } 1 0 \mathrm { M H z } )$ [21]. During low frequency sonication, a large number of compressions and rarefactions take place, which delays the collapse stage and allows volatile compounds to move into the gas phase. Hydrophobic compounds can successfully be decomposed by low-frequency ultrasound as they migrate through the cavity bubbles and are pyrolysed within or can be thermally decomposed in the gas–liquid interface. The delayed growth and prolonged collapse of the bubbles, on the other hand, induces radical scavenging and recombination and inhibits hydroxylic radicals’ transfer to the bulk solution [22]. When a medium frequency ultrasound is applied, greater energies are released into the liquid because “transient” cavitations collapse more rapidly and violently [21]. Due to the extremely quick explosions, radical scavenging does not usually take place inside the bubble and at the interface. For advanced oxidation processes that aim to destroy nonvolatile organic pollutants by free radical effects, medium frequencies are therefore highly effective [22–24].

# 1.2.2. Power Intensity

The sonochemical reactions strongly depend on the intensity of the sound waves. In most cases, with increasing power, the reaction rate increases too. When high ultrasonic power is applied, a great number of cavitation bubbles are generated in the solution. However, many of these bubbles will come together to form larger, longer lived bubbles which will act as a barrier to the transfer of acoustic energy through the liquid, which is known as the cushion effect [1]. Therefore, it must be realized that intensity cannot be increased indefinitely.

# 1.2.3. Properties of Saturating Gas

The dissolved gas bubbles act as nuclei for cavitation during sonication. However, once the gas stream is terminated, it is dissolved instantly, as ultrasound’s initial effect is degassing [25]. Thus, the fluid is continuously bubbled with gas during all of the sonication process to maintain the continued stream of gas into the bubbles and maintain “extreme” conditions of collapse. Employing gases with large polytropic ratio values is known to enhance the adiabatic conditions in the collapsing bubble and improve sonochemical effects. For this reason, monatomic gases $( { \mathrm { H e } } , \mathbf { A r } ,$ Ne) are used in preference to diatomic gases $( \mathrm { N } _ { 2 } ,$ air, $\mathrm { O } _ { 2 }$ ). It was found that halogenic compounds are more efficiently broken down under argon, and the others (without halogens) are more efficiently degraded under air [26]. When air is selected as the bubbling gas, $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ generation is accompanied by the formation of nitrous and nitrogenous ion and larger yields are obtained due to the reaction of nitrogen with molecular oxygen to form nitric acid and radical species such as •OH, $\bullet \mathrm { N O } _ { 2 }$ , and $\bullet \mathrm { N O } _ { 3 } ,$ accelerating the oxidation process [26].

# 1.2.4. Temperature

Due to increases in the surface tension or viscosity with decreasing temperature, or due to a decrease in the vapor pressure, the threshold limit is reported to increase with decreasing temperature [26]. Moreover, as the temperature increases, the effects of cavitational collapse are reduced.

# 1.2.5. Physicochemical Properties of the Pollutant

Physicochemical properties of the compound are also very important as they determine the sonochemical reaction site. Hydrophobic compounds move into the gas bubble itself or the bubble–liquid interface [27–29]. Therefore, power ultrasound at low frequencies (which generates long-lived “stable” cavities) is more efficient for the pyrolytic degradation of such compounds [28]. Hydrophilic compounds, on the other hand, stay in the bulk solution, due to the repulsive forces between the compound and the hydrophobic bubble surfaces. Therefore, their destruction depends on the quantity of hydroxyl radicals ejected to the liquid medium, which is at its maximum during medium frequency sonication (where collapse is “transient”) [29]. Thermal decomposition of such non-volatile compounds may also occur at the bubble–liquid interface, but hydroxylation in the bulk medium is much more effective.

# 1.2.6. Addition of Solids

Solid catalysts, including $\mathrm { A l } _ { 2 } \mathrm { O } _ { 3 }$ , $\mathrm { S i O } _ { 2 }$ , talc, ceramic disks and glass beads, are widely used to enhance cavitation effects in the reaction medium. In pure liquids, cavity bubbles are spherical during collapse because their surroundings are uniform. In the presence of a solid surface, the cavity collapse dynamics change dramatically. Approaching a solid boundary, cavity collapse is very asymmetric and generates high-speed jets of liquid [21]. Liquid jets drive into the heterogeneous surfaces with velocities of roughly $4 0 0 \ k m \ h ^ { - 1 }$ and cause severe damage at the point of impact, producing newly exposed, highly reactive surfaces [21].

# 2. Applications of Ultrasound in Water and Wastewater Decontamination

In the last two decades, considerable interest has been shown in the application of ultrasound as an advanced oxidation process (AOP) for water decontamination. As described in the previous section, sonication of water leads to extreme reaction conditions, leading to thermal decomposition of water to produce hydroxyl radicals. Under these conditions, all organic pollutants including emerging micropollutants such as toxic azo dyes, endocrine disrupting compounds, pharmaceuticals and personal care products are decomposed by reactions with these radicals and direct pyrolysis [30,31].

Many researchers studied the effect of sonication as a pretreatment to minimize toxicity and enhance biodegradability before secondary treatment [32–34]. Moreover, a large number of studies have been conducted on the application of ultrasound as a post-treatment technique for the destruction of refractory compounds in effluent streams [35]. It was concluded that ultrasound is not only an efficient pretreatment method to improve biodegradability but also an effective post-treatment option for the elimination of refractory compounds from water. However, much of the experiments of ultrasonic treatment were carried out at laboratory scale.

The advantages of ultrasound in water treatment are low maintenance requirements and low energy efficiency of alternative methods (e.g., ozonolysis, UV photolysis). Moreover, ultrasound waves, unlike ultraviolet light, are able to be fully transmitted through opaque systems. Therefore, in contrast to many other processes that are negatively affected when suspended solids of effluent increase, in ultrasonic processes efficiency may even improve by increase of turbidity or suspended solids [26,36]. If the reaction mechanism is pyrolysis, cavitational intensity and efficiency can be increased by the addition of solid particles, gases and adjustment of other parameters discussed in the previous section. If the main reaction mechanism is free radical attack, the combination of ultrasound with other advanced oxidation processes (hydrogen peroxide, ozone and photocatalysis) is reported to successfully improve the system [36].

In addition to degradation and removal of pollutants, ultrasonic irradiation can also be used for disinfection [37]. Nevertheless, the use of high ultrasound intensities is required to obtain $1 0 0 \%$ kill rates. Therefore, the procedure might be costly for general microbiological decontamination. However, combination of ultrasonic irradiation with other disinfection techniques is known to enhance the kill rates of certain microorganisms that are resistant to existing biocidal, ultraviolet light and heat treatment technologies. Recent studies have, therefore, explored the use of low-frequency ultrasound in combination with chlorination, ozonation, electrolysis, various adsorbents and semiconductors that act as heterogeneous catalysts. According to those studies, the combined treatments have been able to achieve excellent disinfection efficiencies. Operating conditions such as intensity and frequency of ultrasound, irradiation time, and characteristics of water may also determine process efficiency. Very limited studies in the past have shown the effectiveness of ultrasound in removing viruses from water [38]. Gogate (2007) conducted a detailed study on the application of various ultrasonic reactors for water disinfection and concluded that the combined efforts of chemists and physicists are needed to use ultrasound technology efficiently at an industrial scale [37].

# 3. Ultrasonic Sludge Pretreatment

Conventional activated sludge processes for wastewater treatment transform organic pollutants into $\mathrm { C O } _ { 2 }$ , water and biomass. Due to stringent sludge disposal regulations worldwide, the processing and ultimate disposal of excess biomass known as waste activated sludge (WAS) is one of the major problems in biochemical wastewater treatment, because it accounts for approximately $3 5 \mathrm { - } 6 0 \%$ of the whole operation cost [39]. As a consequence, there are numerous studies worldwide on the development of low-cost WAS treatment or stabilization technologies. The most favorable of all so far has been anaerobic digestion, which is well recognized with its capability for energy production.

The cost-effectiveness of anaerobic digestion (AD) is not only based on its capacity to produce renewable energy in form of methane gas, but also for rendering high degrees of mass reduction and stabilization. However, the process has a major drawback with its slow hydrolysis step, which leads to large fermenters and excessive space requirements. Thus, the only way to enhance the performancepossible by pre-treatment of the sludge to improve the biodegradability of the solids. and efficiency of AD processes is to accelerate the rate-limiting hydrolysis step [40,41], which is possible by pre-treatment of the sludge to improve the biodegradability of the solids.

Pretreatment of WAS for enhanced solids biodegradability is possible by biological, thermal, mechanical (ultrasound, high pressure, lysis), chemical (oxidation, ozonation) and alkali methods [42]. Amongst them, ultrasonic pretreatment has become very popular due to several inherent merits of US, such as no chemical requirements, efficient sludge disintegration, and improvements in digester stability [42].Ultraso

Ultrasonic disintegration of waste activated sludge is a well-known method of breaking uprobial cells to extract the intracellular material in them [43]. Figure 2 represents a typical layout microbial cells to extract the intracellular material in them [43]. Figure 2 represents a typical layoutof an activated sludge process and options for bio-mass disintegration. Ultrasound de-agglomerates of an activated sludge process and options for bio-mass disintegration. Ultrasound de-agglomeratesbiological flocs and disrupts large organic particles into smaller size particles by the formation and biological flocs and disrupts large organic particles into smaller size particles by the formationimplosion of cavitation bubbles [44]. The shear forces produced by high pressure waves break down and implosion of cavitation bubbles [44]. The shear forces produced by high pressure wavesbacterial cell walls and release intracellular substances into the aqueous phase [42]. Moreover, break down bacterial cell walls and release intracellular substances into the aqueous phase [42].ultrasonic pretreatment improves volatile solid reduction and biogas production. The only Moreover, ultrasonic pretreatment improves volatile solid reduction and biogas production. The onlydisadvantage of ultrasonic methods is that they require substantial energy for effective disintegration disadvantage of ultrasonic methods is that they require substantial energy for effective disintegration ofof high-solid wastes. However, the high energy requirements can be reduced by combining high-solid wastes. However, the high energy requirements can be reduced by combining ultrasonicationultrasonication with chemical processes to allow different mechanisms of action for disintegration. with chemical processes to allow different mechanisms of action for disintegration.

![](images/fd4e654c97b1152a835cf925f1e70bf2a30a53a9123e2e3e316272b8eb87cecf.jpg)  
Figure 2. (a) Typical layout of an activated sludge process. $\scriptstyle \left( { \otimes } \right)$ options for bio-mass disintegration.) (b) Ultrasound system for improvement of biogas production on a farmland biogas plant in (b) Ultrasound systeLöhndorf, Germany.

In the literature, many studies reveal the efficiency of the WAS pretreatment by short wave In the literature, many studies reveal the efficiency of the WAS pretreatment by short waveultrasonication. According to Savun et al. (2012), sonication is a suitable method for rendering ultrasonication. According to Savun et al. (2012), sonication is a suitable method for renderingdisintegration and organic solutes transfer from solids into the aqueous phase to enhance the disintegration and organic solutes transfer from solids into the aqueous phase to enhance thebiodegradability of the sludge. In addition, the degree of disintegration is directly proportional to the biodegradability of the sludge. In addition, the degree of disintegraenergy input, the applied ultrasound dose or the contact time [45].

rgy input, the applied ultrasound dose or the contact time [45]. The effects of various ultrasonication parameters, including frequency, duration and intensity, and their effects on the characteristics of sludge have been studied by many researchers and summarized in the following subsections.

# 3.1. Sonication Frequency

Both hydromechanical shear forces and their sonochemical effects can contribute to the ultrasonic disintegration of sewage sludge. According to Portenlanger (1999), macromolecules with a molar mass above 40,000 are disrupted by the hydromechanical shear forces produced by ultrasound and the mechanical forces are most effective at frequencies below $1 0 0 \mathrm { k H z }$ . Sonochemical degradation processes can occur in a broad ultrasound frequency range from $2 0 \mathrm { k H z }$ up to about 1 MHz. The highest efficiency of sonochemical reactions was observed at more than $1 0 0 ~ \mathrm { k H z }$ [45]. Thiem et al. (2001), having studied the process at different frequencies and within the range of already explored frequencies between 41 and $3 2 1 7 \mathrm { k H z }$ , found that the disintegration of WAS was most effective at the lower end, showing that ultrasonic sludge disintegration is most effective at low ultrasound frequencies and hydromechanical shear forces produced by ultrasonic cavitation are predominantly responsible for sludge disintegration [45].

# 3.2. Energy/Power Input and Sonication Time

The economy of an ultrasound system is primarily governed by the power (W or kW) or energy $\mathrm { ( J }$ or kJ) input supplied. Thus, quantification of energy/power input needed to obtain a desired degree of disintegration is a key factor in selecting the ultrasound system for field application. The power or energy supplied for sludge disintegration can be expressed in a number of ways, such as specific energy (kJ (kg Total Solids) $^ { - 1 }$ ), dose $( \mathrm { J ~ L ^ { - 1 } } )$ , density $( \textrm { W L } ^ { - 1 } )$ and intensity $( \mathsf { W } \thinspace \mathrm { c m } ^ { - 2 } ) ,$ .

# 4. Sonochemical Synthesis of Nanoparticles

One of the most important applications of sonochemistry has been the synthesis of nanoparticles. Among a variety of methods, ultrasonic techniques have received special attention via their ability to provide very small dimensions, specifically $2 { - } 5 0 \mathrm { n m }$ [46]. Some of these fine particles, owing to their massive surface area, are demonstrated to act as excellent catalysts in water chemistry. Sonolytic production of nanoparticles involves the reduction of metals by primary and secondary radicals, which generate during the formation, growth and violent collapse of acoustic cavity bubbles [47,48]. The chemical reactions describing the process are as follows [48]:

$$
\mathrm { H } _ { 2 } \mathrm { O }  { \bullet \mathrm { O H } + \bullet \mathrm { H } }
$$

$$
\bullet \mathrm { H } + \bullet \mathrm { H }  \mathrm { H } _ { 2 }
$$

$$
\bullet \mathrm { H } + \bullet \mathrm { O H }  \mathrm { H } _ { 2 } \mathrm { O }
$$

$$
\mathrm { R H } + \bullet \mathrm { O H } ( \mathrm { o r } \bullet \mathrm { H } )  \mathrm { r e d u c i n g } \ s p e c i e s + \mathrm { H } _ { 2 } \mathrm { O } ( \mathrm { o r } \mathrm { H } _ { 2 } )
$$

$$
\mathrm { M ^ { + n } + \bullet H / H _ { 2 } / \bullet R  M ^ { 0 } }
$$

where: ${ { \bf { M } } ^ { { \bf { n } } + } }$ corresponds to a metal ion and RH to an organic additive.

Reactions Equations (6) and (7) show the formation of reducing agents: (i) $\bullet \mathrm { H }$ from pyrolysis of water inside the collapsing cavity bubbles, (ii) $\mathrm { H } _ { 2 }$ from the reaction of RH with •OH or •H. Reaction Equation (10) shows the formation of secondary radicals $( \bullet \mathrm { R } )$ from pyrolysis of the organic additive. In the presence of these species, the metal salt is readily reduced to the zero-valent form $( \mathbf { M } ^ { 0 } )$ ), which is then converted to ${ \bf M } _ { ~ \mathrm { n + 1 } } ^ { 0 }$ via adsorption onto ${ \bf M } _ { \mathrm { ~ n ~ } } ^ { 0 }$ . The organic additives, which function as stabilizers, are generally alcohols, surfactants and water-soluble polymers.

Preparation of metallic nanoparticles by sonochemical techniques is closely related to the ambient and applied conditions, such as temperature, contact time, metal concentration, frequency, and organic additives [49,50]. For example, the particle size is inversely proportional to the concentration of the stabilizer (e.g., an alcohol) and the alkyl chain length due to the fact that alcohols adsorbed on the surface of metal nuclei restrict the enlargement of particle size via stabilization [46,51]. The type and concentration of dissolved gases in the solution also affects the rate of reduction, and faster rates are achieved in the presence of monoatomic gas molecules (due to higher collapse temperatures) [52]. Applied frequency also plays a critical role in controlling particle size [8]. The effect of frequency is based on the fact that sonochemical reactors are subject to standing waves, i.e., the number of active cavitating bubbles is a function of the frequency and reaction volume [8].

The synthesis of nanoparticles by sonochemical methods may be an alternative green reductant source for green chemistry if combined with natural eco-friendly starting materials and stabilizing agents. The distinctive advantages of this method over all chemical methods (e.g., sodium borohydride, hydrogen, alcohol) are: (i) no chemical addition (except the stabilizer); (ii) reasonably fast reaction rates; and (iii) production of ultra-fine particles [47].

# 5. Conclusions

Based on the literature review, it can be concluded that ultrasonic irradiation is an excellent option for the treatment of refractory compounds in water and wastewater. The major advantages of this process are the reduction in the toxicity without generating any sludge, and easy and safe operation. In addition, ultrasound is a promising technology used in the pretreatment of waste activated sludge. Ultrasonic disintegration is one of the most effective pretreatment methods owing to the capacity of ultrasound to break-up microbial cells and extract the intracellular material. Recently, the use of ultrasound in different areas of nanochemistry and related fields of nanotechnology has attracted the attention of scientists. Ultrasound is an efficient, inexpensive and environmentally-friendly method of nanoparticles/nanocomposites synthesis. Hence, ultrasonic irradiation can be effectively used as a “green” technology in the synthesis of the nanomaterials, in assisting the oxidative destruction of emerging water contaminants and in sludge pretreatment to facilitate solubilization and biodegradability. Although there are many studies in the literature on the use of ultrasound for different environmental purposes, most of these studies are small-scale. Further investigations are needed on the cost-effectiveness of the proposed processes to shed light on their large-scale applicability.

Funding: The study is funded by the Istanbul University Research Fund (BAP) through the project MAB-2019-34967.

Conflicts of Interest: The authors declare no conflict of interest.

# References

1. Suslick, K.S. Sonochemistry. Science 1990, 247, 1439–1445. [CrossRef] [PubMed]   
2. Shut, V.N.; Mozzharov, S.E. Properties of ultrafine copper-containing powders prepared by a sonoelectrochemical method. Inorg. Mater. 2017, 53, 883–889. [CrossRef]   
3. Mason, T.J.; Peters, D. Practical Sonochemistry: Power Ultrasound Uses and Applications; Woodhead Publishing: Cambridge, UK, 2002.   
4. Mason, T.J. Chemistry with Ultrasound; Elsevier Applied Science: New York, NY, USA, 1990.   
5. Fischer, C.H.; Hart, E.J.; Henglein, A. Ultrasonic irradiation of water in the presence of oxygen 18, 18O2: isotope exchange and isotopic distribution of hydrogen peroxide. J. Phys. Chem. 1986, 90, 1954–1956. [CrossRef]   
6. Lorimer, J.P.; Mason, T.J.; Fiddy, K. Enhancement of chemical reactivity by power ultrasound: An alternative interpretation of the hot spot. Ultrasonics 1991, 29, 338–343. [CrossRef]   
7. Ameta, S.C.; Ameta, R.; Ameta, G. (Eds.) Sonochemistry: An Emerging Green Technology; CRC Press: Boca Raton, TL, USA, 2018.   
8. Okitsu, K.; Ashokkumar, M.; Grieser, F. Sonochemical synthesis of gold nanoparticles: Effects of ultrasound frequency. J. Phys. Chem. B 2005, 109, 20673–20675. [CrossRef] [PubMed]   
9. Bokhale, N.B.; Bomble, S.D.; Dalbhanjan, R.R.; Mahale, D.D.; Hinge, S.P.; Banerjee, B.S.; Gogate, P.R. Sonocatalytic and sonophotocatalytic degradation of rhodamine 6G containing wastewaters. Ultrason. Sonochem. 2014, 21, 1797–1804. [CrossRef] [PubMed]   
10. Gao, Y.Q.; Gao, N.Y.; Wang, W.; Kang, S.F.; Xu, J.H.; Xiang, H.M.; Yin, D.Q. Ultrasound-assisted heterogeneous activation of persulfate by nano zero-valent iron (nZVI) for the propranolol degradation in water. Ultrason. Sonochem. 2018, 49, 33–40. [CrossRef]   
11. Khataee, A.; Eghbali, P.; Irani-Nezhad, M.H.; Hassani, A. Sonochemical synthesis of WS2 nanosheets and its application in sonocatalytic removal of organic dyes from water solution. Ultrason. Sonochem. 2018, 48, 329–339. [CrossRef]   
12. Kwak, H.Y. Hydrodynamic Aspects on Sonoluminescence. In Phosphors: Synthesis and Applications; CRC Press: Boca Raton, TL, USA, 2018; Volume 1.   
13. Brenner, T.; Kiessler, B.; Radosta, S.; Arndt, T. Processing surface sizing starch using oxidation, enzymatic hydrolysis and ultrasonic treatment methods—Preparation and application. Carbohydr. Polym. 2016, 138, 273–279. [CrossRef]   
14. Suslick, K.S.; Eddingsaas, N.C.; Flannigan, D.J.; Hopkins, S.D.; Xu, H. The chemical history of a bubble. Acc. Chem. Res. 2018, 51, 2169–2178. [CrossRef]   
15. Shimizu, N.; Ogino, C.; Dadjour, M.F.; Murata, T. Sonocatalytic degradation of methylene blue with TiO2 pellets in water. Ultrason. Sonochem. 2007, 14, 184–190. [CrossRef]   
16. Suslick, K.S.; Price, G.J. Applications of ultrasound to materials chemistry. Annu. Rev. Mater. Sci. 1999, 29, 295–326. [CrossRef]   
17. Muravieva, O.V.; Bogdan, O.P.; Zlobin, D.V.; Milich, V.N.; Maslennikov, S.I.; Dudina, Y.S. Experimental evaluation of the ultrasound radiation intensity of medical equipment based on the analysis of the sizes of equilibrium gas bubbles in a liquid. Instrum. Exp. Tech. 2017, 60, 137–142. [CrossRef]   
18. Adewuyi, Y.G. Sonochemistry: Environmental science and engineering applications. Ind. Eng. Chem. Res. 2001, 40, 4681–4715. [CrossRef]   
19. Weavers, L.; Frim, J.; Rathman, J.; Pee, G. Ultrasonic Destruction of Surfactants: Application to Industrial Wastewaters; IWA Publishing: London, UK, 2015.   
20. Wood, R.J.; Lee, J.; Bussemaker, M.J. A parametric review of sonochemistry: Control and augmentation of sonochemical activity in aqueous solutions. Ultrason. Sonochem. 2017, 38, 351–370. [CrossRef]   
21. Suslick, K.S.; Grinstaff, M.W.; Kolbeck, K.J.; Wong, M. Characterization of sonochemically prepared proteinaceous microspheres. Ultrason. Sonochem. 1994, 1, S65–S68. [CrossRef]   
22. Abdurahman, M.H.; Abdullah, A.Z. Mechanism and reaction kinetic of hybrid ozonation-ultrasonication treatment for intensified degradation of emerging organic contaminants in water: A critical review. Chem. Eng. Process. Process Intensif. 2020, 154, 108047. [CrossRef]   
23. Lepoint, T.; Mullie, F. What exactly is cavitation chemistry? Ultrason. Sonochem. 1994, 1, S13–S22. [CrossRef]   
24. Petrier, C.; Jeunet, A.; Luche, J.L.; Reverdy, G. Unexpected frequency effects on the rate of oxidative processes induced by ultrasound. J. Am. Chem. Soc. 1992, 114, 3148–3150. [CrossRef]   
25. Thompson, L.H.; Doraiswamy, L.K. Sonochemistry: Science and engineering. Ind. Eng. Chem. Res. 1999, 38, 1215–1249. [CrossRef]   
26. Mason, T.J.; Lorimer, J.P. Applied Sonochemistry: The Uses of Power Ultrasound in Chemistry and Processing; Wiley: Hoboken, NJ, USA, 2002; ISBN 3-527-30205-0.   
27. Alegria, A.E.; Lion, Y.; Kondo, T.; Riesz, P. Sonolysis of aqueous surfactant solutions: Probing the interfacial region of cavitation bubbles by spin trapping. J. Phys. Chem. 1989, 93, 4908–4913.   
28. Weavers, L.K.; Ling, F.H.; Hoffmann, M.R. Aromatic compound degradation in water using a combination of sonolysis and ozonolysis. Environ. Sci. Technol. 1998, 32, 2727–2733. [CrossRef]   
29. Sato, C.; Ogle, S.M. Modeling tetrachloroethylene decomposition in photosonolysis reactor. J. Environ. Eng. 2003, 129, 136–146. [CrossRef]   
30. Savun-Hekimo ˘glu, B.; Ince, N.H. Decomposition of PPCPs by ultrasound-assisted advanced Fenton reaction: A case study with salicylic acid. Ultrason. Sonochem. 2017, 39, 243–249. [CrossRef] [PubMed]   
31. Savun-Hekimo ˘glu, B.; Ince, N.H. Sonochemical and sonocatalytic destruction of methylparaben using raw, modified and SDS-intercalated particles of a natural clay mineral. Ultrason. Sonochem. 2019, 54, 233–240. [CrossRef]   
32. Gonze, E.; Pillot, S.; Valette, E.; Gonthier, Y.; Bernis, A. Ultrasonic treatment of an aerobic activated sludge in a batch reactor. Chem. Eng. Process. Process Intensif. 2003, 42, 965–975. [CrossRef]   
33. Pérez-Elvira, S.I.; Ferreira, L.C.; Donoso-Bravo, A.; Fdz-Polanco, M.; Fdz-Polanco, F. Full-stream and part-stream ultrasound treatment effect on sludge anaerobic digestion. Water Sci. Technol. 2010, 61, 1363–1372. [CrossRef]   
34. El-Hadj, T.B.; Dosta, J.; Márquez-Serrano, R.; Mata-Alvarez, J. Effect of ultrasound pretreatment in mesophilic and thermophilic anaerobic digestion with emphasis on naphthalene and pyrene removal. Water Res. 2007, 41, 87–94. [CrossRef]   
35. Naddeo, V.; Belgiorno, V.; Kassinos, D.; Mantzavinos, D.; Meric, S. Ultrasonic degradation, mineralization and detoxification of diclofenac in water: Optimization of operating parameters. Ultrason. Sonochem. 2010, 17, 179–185. [CrossRef]   
36. Mahvi, A.H.; Ghanbarian, M.; Nasseri, S.; Khairi, A. Mineralization and discoloration of textile wastewater by TiO2 nanoparticles. Desalination 2009, 239, 309–316. [CrossRef]   
37. Gogate, P.R. Application of cavitational reactors for water disinfection: Current status and path forward. J. Environ. Manag. 2007, 85, 801–815. [CrossRef]   
38. Scherba, G.; Weigel, R.M.; O’brien, W.D. Quantitative assessment of the germicidal efficacy of ultrasonic energy. Appl. Environ. Microbiol. 1991, 57, 2079–2084. [CrossRef]   
39. Neyens, E.; Baeyens, J. A review of thermal sludge pre-treatment processes to improve dewaterability. J. Hazard. Mater. 2003, 98, 51–67. [CrossRef]   
40. Mao, T.; Hong, S.Y.; Show, K.Y.; Tay, J.H.; Lee, D.J. A comparison of ultrasound treatment on primary and secondary sludges. Water Sci. Technol. 2004, 50, 91–97. [CrossRef]   
41. Eastman, J.A.; Ferguson, J.F. Solubilization of particulate organic carbon during the acid phase of anaerobic digestion. J. Water Pollut. Control Fed. 1981, 53, 352–366.   
42. Savun, B.; Neis, U.; Ince, N.H.; Yenigün, O. Pretreatment of sewage sludge by low-frequency ultrasound. J. Adv. Oxid. Technol. 2012, 15, 374–379. [CrossRef]   
43. Nguyen, D.D.; Yoon, Y.S.; Nguyen, N.D.; Bach, Q.V.; Bui, X.T.; Chang, S.W.; Le, H.S.; Guo, W.; Ngo, H.H. Enhanced efficiency for better wastewater sludge hydrolysis conversion through ultrasonic hydrolytic pretreatment. J. Taiwan Inst. Chem. Eng. 2017, 71, 244–252. [CrossRef]   
44. Filibeli, A.; Erden, G.; Gunduz, C. Ultrasonic pre-treatment of wastewater sludge from a meat processing industry. Braz. J. Chem. Eng. 2018, 35, 909–918. [CrossRef]   
45. Hua, I.; Hoffmann, M.R. Optimization of ultrasonic irradiation as an advanced oxidation technology. Environ. Sci. Technol. 1997, 31, 2237–2243. [CrossRef]   
46. Caruso, R.A.; Ashokkumar, M.; Grieser, F. Sonochemical formation of gold sols. Langmuir 2002, 18, 7831–7836. [CrossRef]   
47. Zhang, Y.; Zhou, F.; Zhao, M.; Lin, L.; Ning, Z.; Sun, B. Soy peptide nanoparticles by ultrasound-induced self-assembly of large peptide aggregates and their role on emulsion stability. Food Hydrocoll. 2018, 74, 62–71. [CrossRef]   
48. Islam, M.H.; Paul, M.T.; Burheim, O.S.; Pollet, B.G. Recent developments in the sonoelectrochemical synthesis of nanomaterials. Ultrason. Sonochem. 2019, 59, 104711. [CrossRef] [PubMed]   
49. Sonawane, S.H.; Teo, B.M.; Brotchie, A.; Grieser, F.; Ashokkumar, M. Sonochemical synthesis of ZnO encapsulated functional nanolatex and its anticorrosive performance. Ind. Eng. Chem. Res. 2010, 49, 2200–2205. [CrossRef]   
50. Jin, Q.; Kang, S.T.; Chang, Y.C.; Zheng, H.; Yeh, C.K. Inertial cavitation initiated by polytetrafluoroethylene nanoparticles under pulsed ultrasound stimulation. Ultrason. Sonochem. 2016, 32, 1–7. [CrossRef]   
51. Bang, J.H.; Suslick, K.S. Applications of ultrasound to the synthesis of nanostructured materials. Adv. Mater. 2010, 22, 1039–1059. [CrossRef] [PubMed]   
52. Okitsu, K.; Cavalieri, F. Synthesis of Micro-nanoparticles Using Ultrasound-Responsive Biomolecules. In Sonochemical Production of Nanomaterials; Springer: Cham, Switzerland, 2018; pp. 39–62.

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.